/**
  * @file    svc.h
  * @author  A0406448
  * @date    14/11/2014
  ******************************************************************************/
/* Copyright (C) 2013-2019 Texas Instruments Incorporated - http://www.ti.com
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SVC_H_
#define SVC_H_

#include "sys_common.h"

#pragma SWI_ALIAS(unimplementedSVC,     0);
#pragma SWI_ALIAS(switchCpuMode,        1);
#pragma SWI_ALIAS(switchToSystemMode,   2);
#pragma SWI_ALIAS(switchToUserMode,     3);
#pragma SWI_ALIAS(writePrivRegister32, 33);
#pragma SWI_ALIAS(writePrivRegister8,  34);
#pragma SWI_ALIAS(testReentrantSVC,    35);

void     unimplementedSVC(void); /* Used to test fault handler */
uint32_t switchCpuMode(uint32_t u32ModeNum);
void     switchToSystemMode(void);
void     switchToUserMode(void);

/* The following SVC functions are implemented at C level */
uint32_t writePrivRegister32(uint32_t * pu32Address, uint32_t u32Value);
uint8_t  writePrivRegister8(uint8_t * pu8Address, uint8_t u8Value);
uint32_t testReentrantSVC(uint32_t * pu32Address, uint32_t u32Repetition);

#endif /* SVC_H_ */
